if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

local output = resize.location.std.checkers[1].mirror

set_user_input_filter(permissive_filter)
function tutorial_routine()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    embed(announce("You're on your own for this factory.", 4, 0.09, captured_cancel()))
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("You must make a column of four blocks.", 0.1),
      blinking_box_at_game_lambda(output)
    ), captured_cancel()))
    state:suppress_toolbar_menu(false);
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Use portals and welders for this.", 0.1),
      highlight_menu_item_lambda("toolbar_3"),
      highlight_menu_item_lambda("toolbar_4")
    ), captured_cancel()))
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("You may also place blank blocks.", 0.1),
      highlight_menu_item_lambda("toolbar_1")
    ), captured_cancel()))
    embed(pause(0.25))
    embed(ramp(4, do_all(
      announce_lambda("Use the delete tool if you mess up", 0.08),
      announce_lambda("(Or press Z to undo)", 0.06, -0.08),
      highlight_menu_item_lambda("toolbar_0")
    ), captured_cancel()))
    state:suppress_interface_hints(false);
    state:suppress_transport_menu(false);
    set_user_input_filter(permissive_filter)
    embed(pause(0.25))
    embed(announce("Good luck!", 3, 0.15, captured_cancel()))
  end)
end
if not played_in_past then
  draw_interpreted_routine(tutorial_routine())
end
